#!/bin/bash

# custom config
DATA=./data
TRAINER=MYTrainer

DATASET=$1
CFG=$2  # config file
CTP=$3  # class token position (end or middle)
NCTX=$4  # number of context tokens
SHOTS=$5  # number of shots (1, 2, 4, 8, 16)
CSC=$6  # class-specific context (False or True)
CLASS_EQULE=$7  # CLASS_EQULE True of False
TAG=$8 # log tag (multiple_models_random_init or rn50_random_init)
FP=$9 # portion of false positive training samples per class
ENCODE_TYPE=${10} # Purification method
FORCE_RUN=${11}
GCE=${12}
CLEAN_TYPE=${13}
SEED=${14}
FP_TYPE=${15}

if [ "$FP_TYPE" = "ASYM" ]
then 
    FP_TYPE='asym'
else
    FP_TYPE='sym'
fi

if [ "$TAG" = "debug" ]
then
    SEEDSET=$SEED
else
    # SEEDSET="1 2 3 4 5 6 7 8 9 10"
    # SEEDSET="1 2 3 4 5"
    SEEDSET="2"
fi

if [ "$GCE" = "True" ]
then
    ROBUSTLOSS=" --use-robustloss "
else
    ROBUSTLOSS=" "
fi

for SEED in $SEEDSET
do  
    DIR=./output/${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots_EQULE_${CLASS_EQULE}_${TAG}/nctx_${NCTX}_csc_${CSC}_ctp_${CTP}_fp_${FP}_encode_type_${ENCODE_TYPE}_clean_type_${CLEAN_TYPE}/seed_${SEED}
    if [ "$FORCE_RUN" = "True" ]
    then
        echo "Remove Directory for Force Run"
        rm -r $DIR
    fi

    if [ -d "$DIR" ]; then
        echo "Results are available in ${DIR}. Skip this job"
    else
        echo "Run this job and save the output to ${DIR}"
        python my_train.py \
        --root ${DATA} \
        ${ROBUSTLOSS} \
        --seed ${SEED} \
        --trainer ${TRAINER} \
        --dataset-config-file configs/datasets/${DATASET}.yaml \
        --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
        --output-dir ${DIR} \
        --fp ${FP} \
        --encode-type ${ENCODE_TYPE} \
        --clean-type ${CLEAN_TYPE} \
        --fp-type ${FP_TYPE} \
        TRAINER.MYTrainer.N_CTX ${NCTX} \
        TRAINER.MYTrainer.CSC ${CSC} \
        TRAINER.MYTrainer.CLASS_TOKEN_POSITION ${CTP} \
        DATASET.NUM_SHOTS ${SHOTS} \
        DATASET.CLASS_EQULE ${CLASS_EQULE}
    fi
done

        